/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.ai;

import java.util.Random;
import lotr.common.LOTRMod;
import lotr.common.entity.animal.LOTREntityRabbit;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class LOTREntityAIRabbitEatCrops
extends EntityAIBase {
    private LOTREntityRabbit theRabbit;
    private double xPos;
    private double yPos;
    private double zPos;
    private double moveSpeed;
    private World theWorld;
    private int pathingTick;
    private int eatingTick;
    private int rePathDelay;

    public LOTREntityAIRabbitEatCrops(LOTREntityRabbit rabbit, double d) {
        this.theRabbit = rabbit;
        this.moveSpeed = d;
        this.theWorld = rabbit.field_70170_p;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        Vec3 vec3;
        if (!LOTRMod.canGrief(this.theWorld)) {
            return false;
        }
        if (this.theRabbit.func_70681_au().nextInt(20) == 0 && (vec3 = this.findCropsLocation()) != null) {
            this.xPos = vec3.field_72450_a;
            this.yPos = vec3.field_72448_b;
            this.zPos = vec3.field_72449_c;
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        if (!LOTRMod.canGrief(this.theWorld)) {
            return false;
        }
        if (this.pathingTick < 200 && this.eatingTick < 60) {
            int i = MathHelper.func_76128_c((double)this.xPos);
            int j = MathHelper.func_76128_c((double)this.yPos);
            int k = MathHelper.func_76128_c((double)this.zPos);
            return this.canEatBlock(i, j, k);
        }
        return false;
    }

    public void func_75251_c() {
        this.pathingTick = 0;
        this.eatingTick = 0;
        this.rePathDelay = 0;
        this.theRabbit.setRabbitEating(false);
    }

    public void func_75246_d() {
        if (this.theRabbit.func_70092_e(this.xPos, this.yPos, this.zPos) > 1.0) {
            this.theRabbit.setRabbitEating(false);
            this.theRabbit.func_70671_ap().func_75650_a(this.xPos, this.yPos - 0.5, this.zPos, 10.0f, (float)this.theRabbit.func_70646_bf());
            --this.rePathDelay;
            if (this.rePathDelay <= 0) {
                this.rePathDelay = 10;
                this.theRabbit.func_70661_as().func_75492_a(this.xPos, this.yPos, this.zPos, this.moveSpeed);
            }
            ++this.pathingTick;
        } else {
            this.theRabbit.setRabbitEating(true);
            ++this.eatingTick;
            if (this.eatingTick % 6 == 0) {
                this.theRabbit.func_85030_a("random.eat", 1.0f, (this.theWorld.field_73012_v.nextFloat() - this.theWorld.field_73012_v.nextFloat()) * 0.2f + 1.0f);
            }
            if (this.eatingTick >= 60) {
                this.theWorld.func_147468_f(MathHelper.func_76128_c((double)this.xPos), MathHelper.func_76128_c((double)this.yPos), MathHelper.func_76128_c((double)this.zPos));
            }
        }
    }

    private Vec3 findCropsLocation() {
        Random random = this.theRabbit.func_70681_au();
        for (int l = 0; l < 32; ++l) {
            int k;
            int j;
            int i = MathHelper.func_76128_c((double)this.theRabbit.field_70165_t) + MathHelper.func_76136_a((Random)random, (int)-16, (int)16);
            if (!this.canEatBlock(i, j = MathHelper.func_76128_c((double)this.theRabbit.field_70121_D.field_72338_b) + MathHelper.func_76136_a((Random)random, (int)-8, (int)8), k = MathHelper.func_76128_c((double)this.theRabbit.field_70161_v) + MathHelper.func_76136_a((Random)random, (int)-16, (int)16))) continue;
            return Vec3.func_72443_a((double)((double)i + 0.5), (double)j, (double)((double)k + 0.5));
        }
        return null;
    }

    private boolean canEatBlock(int i, int j, int k) {
        Block block = this.theWorld.func_147439_a(i, j, k);
        return block instanceof BlockCrops && !this.theRabbit.anyFarmhandsNearby(i, j, k);
    }
}

